function getCookie(key,cookiestr) {  

	var keyValue = cookiestr.match('(^|;) ?' + key + '=([^;]*)(;|$)');  
	return keyValue ? keyValue[2] : null;  

}  


var patterns = {

	"(.*?) has posted a new status update$": function(obj,result){

		var ret = {};
		ret.type = "NewStatus";
		ret.text = obj.children(".list_content").text().trim();
		ret.avatar = obj.children("img").attr("src");
		ret.links = {

			status: obj.find("a").last().attr("href"),
			poster: $(obj.find("a")[0]).attr("href")

		}
		ret.name = result[1];

		//console.log(ret);

		return ret;
		

	},

	"(.*?) has replied to your status$": function(obj,result){

		var ret = {};
		ret.type = "OwnStatusReply";
		ret.text = obj.children(".list_content").text().trim();
		ret.avatar = obj.children("img").attr("src");
		ret.links = {

			status: obj.find("a").last().attr("href"),
			poster: $(obj.find("a")[0]).attr("href")

		}
		ret.name = result[1]

		//console.log(ret);

		return ret;

	},

	"(.+) has replied to (.+)\'s status$": function(obj,result){

		var ret = {};
		ret.type = "OtherStatusReply";
		ret.text = obj.children(".list_content").text().trim();
		ret.avatar = obj.children("img").attr("src");
		ret.links = {

			status: obj.find("a").last().attr("href"),
			owner: $(obj.find("a")[1]).attr("href"),
			poster: $(obj.find("a")[0]).attr("href")
		}

		ret.names = {

			poster: result[1],
			owner: result[2]

		}

		//console.log(ret);

		return ret;

	},

	"(.+) replied to (.+)$": function(obj,result){

		var ret = {};
		ret.type = "TopicReply";
		ret.text = obj.children(".list_content").text().trim();
		ret.avatar = obj.children("img").attr("src");
		ret.links = {

			topic: obj.find("a").last().attr("href"),
			poster: $(obj.find("a")[0]).attr("href")
		}

		ret.names = {

			poster: result[1],
			topic: result[2]

		}

		
		return ret;

	},
	"(.+) brohoofed a post you made in (.+)": function(obj,result){

		var ret = {};
		ret.type = "Brohoof";
		ret.text = obj.children(".list_content").text().trim();
		ret.avatar = obj.children("img").attr("src");
		ret.links = {

			topic: obj.find("a").last().attr("href"),
			post: $(obj.find("a")[1]).attr("href"),
			hoofer: $(obj.find("a")[0]).attr("href")
		}

		ret.names = {

			hoofer: result[1],
			topic: result[2]

		}

		console.log(ret);

		return ret;

	},
	"(.+) has made a reply to their status": function(obj,result){

		var ret = {};
		ret.type = "SelfStatusReply";
		ret.text = obj.children(".list_content").text().trim();
		ret.avatar = obj.children("img").attr("src");
		ret.links = {

			status: obj.find("a").last().attr("href"),
			poster: $(obj.find("a")[0]).attr("href"),
		}

		ret.names = {

			poster: result[1]

		}

		//console.log(ret);

		return ret;

	}

	


}

function parseNotification(obj)
{



	var time = obj.find("span").text();

	obj.find("span").remove();


	
	var text = obj.children(".list_content").text().trim();
	

	for (var pat in patterns)
    {

        var reg = new RegExp(pat);

        var result = reg.exec(text);


        if( result && result.length > 0)
        {
        	

        	var ret = patterns[pat](obj,result);
        	ret.time = time;
        	
        	return ret;


        }


    }

}


$(function(){


	$.ajax("http://mlpforums.com/", {

		complete: function(jqXHR, textStatus)
		{


			var regex1 = /(ipb.vars\[\'session_id\'\]).*?(.{32})';/ // OMG WAS THIS HARD!!


			var result = regex1.exec(jqXHR.responseText);

			localStorage.SessionID = result[2];

			var regex2 = /(ipb.vars\[\'secure_hash\'\]).*?(.{32})';/ // OMG WAS THIS HARD!!


			var result = regex2.exec(jqXHR.responseText);

			localStorage.SecureHash = result[2];

			var regex3 = /ipb\.vars\['member_id'\]\s+=\s+parseInt.\s+(\d+)\s+./

			var result = regex3.exec(jqXHR.responseText);

			localStorage.MemberId = result[1]


		}

	});

	function Update()
	{

		if( localStorage.LastUpdate < Math.round(new Date().getTime() / 1000) + 300 )
		{

		//showInfo();
		//return;

		}


		var url = 'http://mlpforums.com/index.php?s=' + localStorage.SessionID +  '&app=core&module=ajax&section=notifications&do=getlatest';


		$.ajax(	url,
		{
			async: false,
			method: 'post',
			data: {
			
				secure_key: 	localStorage.SecureHash
				
			},
			dataType: "json",
			success: function(data)
			{

				$("#temp").html(data.html);

				parseInfo();

			},
			error: function(g,k,error)
			{

				console.error(error);

			}
		});

		setTimeout(Update,localStorage.updatetime);

	}
	
	Update();

	function parseInfo()
	{

		var temp = $("#temp");

		temp.children("h4").empty();
		
		if ( temp.find("strong").length > 0 )
		{
			
			localStorage.NumNotifs = parseInt(localStorage.NumNotifs) + parseInt(temp.find("strong").length);
			
			
			chrome.browserAction.setBadgeText({ 'text': String(localStorage.NumNotifs) });
		
		} // Find the number of new notifications!


		var data = {

			"entries" : {}
			
		};



		$("#temp")
		.children("ul")
		.children("li")
		.each(function(i, el){

			
			data.entries[i] = parseNotification($(this))

			
			
			//data.entries[i]["text"] = $(this).children(".list_content").text().trim()
			

		});
		
		

		localStorage.Data = JSON.stringify(data);
		localStorage.LastUpdate = Math.round(new Date().getTime() / 1000);

		//console.log(data);



	}
	
});